package easik.sketch.datatype;

import easik.EasikConstants;

/**
 * Class to store individual data type information
 * 
 * @author Kevin Green 2006
 * @version 2006-06-28 Kevin Green
 */
public class DataType {

	/**
	 * The name of the data type
	 */
	private String _typeName; 
	/**
	 * The description of the data type
	 */
	private String _typeDesc; 
	/**
	 * The MySQL type used to represent this data type
	 */
	private String _MySQL_type;
	/**
	 * The Oracle type used to represent this data type
	 */
	private String _Oracle_type;
	
	/**
	 * The DB2 type used to represent this data type
	 */
	private String _DB2_type; 
	/**
	 * The XML type used to represent this data type
	 */
	private String _XML_type;
	/**
	 * The user defined type used to represent this data type
	 */
	private String _user_type;
	
	/**
	 * Default constructor (All varibales)
	 * 
	 * @param inName The name of the data type
	 * @param inDesc The description of the data type
	 * @param inMySQL The MySQL type associated with the data type
	 * @param inOracle The Oracle type associated with the data type
	 * @param inDB2 The DB2 type associated with the data type
	 * @param inXML The XML type associated with the data type
	 * @param inUser The User Defined type associated with the data type
	 */
	public DataType(String inName, String inDesc, String inMySQL, String inOracle, String inDB2, String inXML, String inUser){
		_typeName = inName;
		_typeDesc = inDesc;
		_MySQL_type = inMySQL;
		_Oracle_type = inOracle;
		_DB2_type = inDB2;
		_XML_type = inXML;
		_user_type = inUser;
	}
	
	/**
	 * Defaul Constructor (No Description)
	 * Sets data types to defaults.
	 * 
	 * @param inTypeName Name of the datatype
	 */
	public DataType(String inTypeName){
		_typeName = inTypeName;
		_typeDesc = "";
		_MySQL_type = EasikConstants.MY_SQL_DEFAULT;
		_Oracle_type = EasikConstants.ORACLE_DEFAULT;
		_DB2_type = EasikConstants.DB2_DEFAULT;
		_XML_type = EasikConstants.XML_DEFAULT;
		_user_type = inTypeName;
	}
	
	/**
	 * Default Constructor (Including Description)
	 * Sets data types to defaults.
	 * 
	 * @param inTypeName Name of the datatype
	 * @param inTypeDesc Description of the datatype
	 */
	public DataType(String inTypeName, String inTypeDesc){
		_typeName = inTypeName;
		_typeDesc = inTypeDesc;
		_MySQL_type = EasikConstants.MY_SQL_DEFAULT;
		_Oracle_type = EasikConstants.ORACLE_DEFAULT;
		_DB2_type = EasikConstants.DB2_DEFAULT;
		_XML_type = EasikConstants.XML_DEFAULT;
		_user_type = inTypeName;
	}
	
	/**
	 * Overloaded method to return data type name when used as a strings
	 * 
	 * @return The type name
	 */
	public String toString(){
		return _typeName;
	}
	
	/**
	 * Returns the name of the data type
	 * 
	 * @return The name of the data type
	 */
	public String getTypeName(){
		return _typeName;
	}
	
	/**
	 * Sets the name of the data type
	 * 
	 * @param inTypeName The new name of the data type
	 */
	public void setTypeName(String inTypeName){
		_typeName = inTypeName;
	}
	
	/**
	 * Return the description of the data type
	 * 
	 * @return The description of the data type
	 */
	public String getTypeDesc(){
		return _typeDesc;
	}
	
	/**
	 * Sets the description of the data type
	 * 
	 * @param inTypeDesc The new description of the data type
	 */
	public void setTypeDesc(String inTypeDesc){
		_typeDesc = inTypeDesc;
	}

	/**
	 * @return Returns the _DB2_type.
	 */
	public String get_DB2_type() {
		return _DB2_type;
	}

	/**
	 * @param _db2_type The _DB2_type to set.
	 */
	public void set_DB2_type(String _db2_type) {
		_DB2_type = _db2_type;
	}

	/**
	 * @return Returns the _MySQL_type.
	 */
	public String get_MySQL_type() {
		return _MySQL_type;
	}

	/**
	 * @param mySQL_type The _MySQL_type to set.
	 */
	public void set_MySQL_type(String mySQL_type) {
		_MySQL_type = mySQL_type;
	}

	/**
	 * @return Returns the _Oracle_type.
	 */
	public String get_Oracle_type() {
		return _Oracle_type;
	}

	/**
	 * @param oracle_type The _Oracle_type to set.
	 */
	public void set_Oracle_type(String oracle_type) {
		_Oracle_type = oracle_type;
	}

	/**
	 * @return Returns the _user_type.
	 */
	public String get_user_type() {
		return _user_type;
	}

	/**
	 * @param _user_type The _user_type to set.
	 */
	public void set_user_type(String _user_type) {
		this._user_type = _user_type;
	}

	/**
	 * @return Returns the _XML_type.
	 */
	public String get_XML_type() {
		return _XML_type;
	}

	/**
	 * @param _xml_type The _XML_type to set.
	 */
	public void set_XML_type(String _xml_type) {
		_XML_type = _xml_type;
	}
}
